/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.entities.components.AEntityA_Base;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.instances.ItemPartGun;
import minecrafttransportsimulator.jsondefs.JSONCameraObject;
import minecrafttransportsimulator.jsondefs.JSONDummyPartProvider;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packloading.PackParser;

public class EntityPlayerGun
extends AEntityF_Multipart<JSONDummyPartProvider> {
    public static final Map<UUID, EntityPlayerGun> playerClientGuns = new HashMap<UUID, EntityPlayerGun>();
    public static final Map<UUID, EntityPlayerGun> playerServerGuns = new HashMap<UUID, EntityPlayerGun>();
    public final IWrapperPlayer player;
    private final RotationMatrix handRotation = new RotationMatrix();
    private int hotbarSelected = -1;
    private IWrapperItemStack gunStack;
    private boolean didGunFireLastTick;
    public PartGun activeGun;

    /*
     * Enabled aggressive block sorting
     */
    public EntityPlayerGun(AWrapperWorld world, IWrapperPlayer placingPlayer, IWrapperNBT data) {
        super(world, placingPlayer, null, data);
        if (data != null) {
            UUID playerUUID = data.getUUID("playerUUID");
            IWrapperPlayer foundPlayer = null;
            for (IWrapperPlayer player : world.getPlayersWithin(new BoundingBox(this.position, 16.0, 16.0, 16.0))) {
                if (!player.getID().equals(playerUUID)) continue;
                foundPlayer = player;
                break;
            }
            if (foundPlayer == null) {
                this.player = null;
                return;
            }
            this.player = foundPlayer;
        } else {
            this.player = placingPlayer;
            this.position.set(this.player.getPosition());
            this.prevPosition.set(this.position);
        }
        if (world.isClient()) {
            if (playerClientGuns.containsKey(this.player.getID())) {
                playerClientGuns.get(this.player.getID()).remove();
            }
            playerClientGuns.put(this.player.getID(), this);
            return;
        }
        if (playerServerGuns.containsKey(this.player.getID())) {
            playerServerGuns.get(this.player.getID()).remove();
        }
        playerServerGuns.put(this.player.getID(), this);
    }

    @Override
    public JSONDummyPartProvider generateDefaultDefinition() {
        JSONDummyPartProvider defaultDefinition = JSONDummyPartProvider.generateDummy();
        JSONPartDefinition fakeDef = (JSONPartDefinition)defaultDefinition.parts.get(0);
        for (AItemPack<?> packItem : PackParser.getAllPackItems()) {
            if (!(packItem instanceof ItemPartGun)) continue;
            ItemPartGun gunItem = (ItemPartGun)packItem;
            if (!((JSONPart)gunItem.definition).gun.handHeld || fakeDef.types.contains(((JSONPart)gunItem.definition).generic.type)) continue;
            fakeDef.types.add(((JSONPart)gunItem.definition).generic.type);
        }
        return defaultDefinition;
    }

    @Override
    public void update() {
        super.update();
        if (this.player != null && this.player.isValid()) {
            ItemPartGun heldGun;
            AItemBase heldItem;
            this.position.set(this.player.getPosition());
            this.motion.set(this.player.getVelocity());
            this.activeGun = null;
            if (!this.parts.isEmpty()) {
                APart part = (APart)this.parts.get(0);
                if (part instanceof PartGun) {
                    this.activeGun = (PartGun)part;
                } else {
                    InterfaceManager.coreInterface.logError("Found a part on a player gun that wasn't a gun!  This shouldn't ever happen...");
                    this.remove();
                    return;
                }
            }
            if (this.player.isSpectator()) {
                if (this.activeGun != null) {
                    this.saveGun(true);
                }
                return;
            }
            if (this.activeGun != null && this.gunStack == null) {
                heldItem = this.player.getHeldItem();
                if (heldItem instanceof ItemPartGun) {
                    heldGun = (ItemPartGun)heldItem;
                    if (((JSONPart)heldGun.definition).gun.handHeld) {
                        this.gunStack = this.player.getHeldStack();
                        this.hotbarSelected = this.player.getHotbarIndex();
                    }
                }
                if (this.activeGun != null && this.gunStack == null) {
                    this.activeGun.remove();
                    return;
                }
            }
            if (!this.world.isClient()) {
                heldItem = this.player.getHeldItem();
                ItemPartGun itemPartGun = heldGun = heldItem instanceof ItemPartGun ? (ItemPartGun)heldItem : null;
                if (this.activeGun != null) {
                    if (heldGun == null || this.activeGun.definition != heldGun.definition || this.hotbarSelected != this.player.getHotbarIndex()) {
                        this.saveGun(true);
                        return;
                    }
                } else if (heldGun != null && ((JSONPart)heldGun.definition).gun.handHeld) {
                    this.gunStack = this.player.getHeldStack();
                    this.addPartFromStack(this.gunStack, this.player, 0, true, false);
                    this.hotbarSelected = this.player.getHotbarIndex();
                }
            }
            if (this.activeGun != null) {
                RotationMatrix playerRotation;
                AEntityB_Existing ridingEntity = this.player.getEntityRiding();
                RotationMatrix rotationMatrix = playerRotation = ridingEntity != null ? ridingEntity.riderRelativeOrientation : this.player.getOrientation();
                if (this.activeGun.isHandHeldGunAimed) {
                    this.position.set(((JSONPart)this.activeGun.definition).gun.handHeldAimedOffset);
                } else {
                    this.position.set(((JSONPart)this.activeGun.definition).gun.handHeldNormalOffset);
                }
                if (((JSONPart)this.activeGun.definition).gun.handHeldModelOffset != null) {
                    this.position.add(((JSONPart)this.activeGun.definition).gun.handHeldModelOffset);
                }
                if (!this.player.isRightHanded()) {
                    this.position.x = -this.position.x;
                }
                this.handRotation.setToZero().rotateX(playerRotation.angles.x);
                this.position.rotate(this.handRotation);
                this.position.add(this.player.isRightHanded() ? -0.3125 : 0.3125, -0.375, 0.0);
                this.handRotation.setToZero().rotateY(playerRotation.angles.y);
                this.position.rotate(this.handRotation);
                this.position.scale(this.player.getVerticalScale());
                if (ridingEntity != null) {
                    this.position.rotate(ridingEntity.orientation);
                    this.orientation.set(ridingEntity.orientation).multiply(playerRotation);
                } else {
                    this.orientation.set(playerRotation);
                }
                this.position.add(this.player.getHeadPosition());
                if (!this.world.isClient()) {
                    if (this.activeGun.state.isAtLeast(PartGun.GunState.FIRING_CURRENTLY)) {
                        this.didGunFireLastTick = true;
                    } else if (this.didGunFireLastTick) {
                        this.saveGun(false);
                    }
                }
                if (this.activeGun.ticksExisted == 1L) {
                    this.activeGun.isHandHeldGunEquipped = true;
                }
                if (this.activeGun.isHandHeldGunAimed || ((JSONPart)this.activeGun.definition).gun.forceHandheldCameras) {
                    if (this.cameraIndex == 0 && this.cameras.size() > 0) {
                        ++this.cameraIndex;
                    }
                } else if (this.cameraIndex != 0) {
                    this.cameraIndex = 0;
                    this.activeCamera = null;
                }
            }
        } else {
            this.remove();
            return;
        }
    }

    @Override
    public AEntityA_Base.EntityAutoUpdateTime getUpdateTime() {
        return AEntityA_Base.EntityAutoUpdateTime.AFTER_PLAYER;
    }

    @Override
    public void removePart(APart part, boolean doFinalTick, boolean notifyClients) {
        super.removePart(part, doFinalTick, notifyClients);
        this.activeGun = null;
    }

    @Override
    public void updatePartList() {
        super.updatePartList();
        this.cameras.clear();
        this.cameraEntities.clear();
        for (APart part : this.allParts) {
            if (((JSONPart)part.definition).rendering == null || ((JSONPart)part.definition).rendering.cameraObjects == null) continue;
            for (JSONCameraObject camera : ((JSONPart)part.definition).rendering.cameraObjects) {
                this.cameras.add(camera);
                this.cameraEntities.add(part);
            }
        }
    }

    @Override
    public boolean requiresDeltaUpdates() {
        return true;
    }

    @Override
    public void remove() {
        super.remove();
        if (this.player != null) {
            if (this.world.isClient()) {
                playerClientGuns.remove(this.player.getID());
            } else {
                playerServerGuns.remove(this.player.getID());
            }
        }
    }

    @Override
    protected void updateCollisionBoxes(boolean requiresDeltaUpdates) {
    }

    @Override
    protected void updateEncompassingBox() {
    }

    private void saveGun(boolean remove) {
        this.gunStack.setData(this.activeGun.save(InterfaceManager.coreInterface.getNewNBTWrapper()));
        this.didGunFireLastTick = false;
        if (remove) {
            this.removePart(this.activeGun, true, true);
        }
    }

    @Override
    public boolean disableRendering() {
        return true;
    }

    @Override
    public IWrapperEntity getController() {
        return this.player;
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        if (this.player != null) {
            data.setUUID("playerUUID", this.player.getID());
        }
        return data;
    }
}

